import { Client } from '@stomp/stompjs'

export const SESSION_NOT_RELIABLE = 4500
export const NO_CLOSE_FRAME = 1006

export class WebSocketListener {
    constructor (url, debug = false) {
        this.client = new Client({
            brokerURL: url,
            reconnectDelay: 5000,
            heartbeatIncoming: 4000,
            heartbeatOutgoing: 4000
        })

        if (debug) this.client.debug = console.log
    }

    on (event, cb) {
        this.client[event] = cb
        return this
    }

    activate () {
        this.client.activate()
    }

    deactivate () {
        this.client.deactivate()
    }

    subscribe (topic, callback, headers) {
        return this.client.subscribe(topic, callback, headers)
    }

    unsubscribe (stombSubscription) {
        this.client.unsubscribe(stombSubscription)
    }
}
