import axios from 'axios/index'
import { router } from 'src/router'
import { cacheAdapterEnhancer } from 'axios-extensions'
import LRUCache from 'lru-cache'
import { showError } from '../utils/notifications'
import { redirectToLogin } from '../utils/utils'
import { BaseEntity } from './entities/BaseEntity'
import * as qs from 'qs'

const CACHE_TIME = 5 * 1000
const CACHE_SIZE = 100

export class BaseApi {
    entity = BaseEntity

    constructor (apiUrl = '/api') {
        this.apiUrl = apiUrl

        // позволяет не писать baseUrl + endpoint, шарит настройки
        this.http = axios.create({
            baseURL: this.apiUrl,
            headers: { 'Cache-Control': 'no-cache' },
            adapter: cacheAdapterEnhancer(axios.defaults.adapter, {
                enabledByDefault: false,
                defaultCache: new LRUCache({ maxAge: CACHE_TIME, max: CACHE_SIZE })
            }),
            paramsSerializer: params => {
                return qs.stringify(params, { arrayFormat: 'repeat', skipNulls: true })
            }
        })

        this.http.interceptors.response.use(
            response => response,
            (error) => {
                let status = error.response.status
                switch (status) {
                    case 401:
                        console.error('401 code global handler call:', error)
                        redirectToLogin(router)
                        break
                    case 403:
                        console.error('403 code global handler call:', error)
                        redirectToLogin(router)
                        showError('Доступ запрещен')
                        break
                    case 500:
                        // router.replace({ name: 'serverError' })
                        showError('Возникла непредвиденная ошибка')
                        break
                }
                return Promise.reject(error)
            }
        )
    }
}
