import GroupEntity from './entities/GroupEntity'
import { UpdateMultipleApi } from './UpdateMultipleApi'

class GroupsApi extends UpdateMultipleApi {
    Entity = GroupEntity

    /**
     * @async
     * @returns {GroupEntity[]}
     */
    async getAll (useCache = false) {
        const { data } = await this.http.get('/', { cache: useCache })
        return data.map(g => new this.Entity(g))
    }

    /**
     * @async
     * @param createGroupDto {CreateUpdateGroupDto}
     * @returns {GroupEntity}
     */
    async create (createGroupDto) {
        const { data } = await this.http.post('/', createGroupDto)

        return new this.Entity(data)
    }
}

export const groupsApi = new GroupsApi('/api/groups')
