import { ModelEntity } from './entities/ModelEntity'
import { ListResponseEntity } from './entities/ListResponseEntity'
import { UpdateMultipleApi } from './UpdateMultipleApi'

class ModelsApi extends UpdateMultipleApi {
    Entity = ModelEntity

    /**
     * @async
     * @param filterOptions {Object}
     * @param useCache {Boolean}
     * @return {Promise<ListResponseEntity<ModelEntity>>}
     */
    async getModels (filterOptions = {}, useCache = false) {
        const { data } = await this.http.get('/', {
            params: filterOptions,
            cache: useCache
        })
        const { items, total } = data
        return new ListResponseEntity(items.map(i => new this.Entity(i)), total)
    }

    /**
     * @async
     * @param id {string}
     * @return {Promise<ModelEntity>}
     */
    async getModel (id) {
        const { data } = await this.http.get(`/${id}`)
        return new this.Entity(data)
    }
}

export const modelsApi = new ModelsApi('/api/models')
