import { NotifyAddressEntity } from './entities/NotifyAddressEntity'
import { UpdateMultipleApi } from './UpdateMultipleApi'

class NotifyApi extends UpdateMultipleApi {
    Entity = NotifyAddressEntity

    /**
     * @param useCache {boolean}
     * @returns {Promise<NotifyAddressEntity[]>}
     */
    async getAddresses (useCache = false) {
        const { data } = await this.http.get('/', { cache: useCache })
        return data.map(c => new NotifyAddressEntity(c))
    }

    /**
     * @param createAddressDto {CreateAddressDto}
     * @returns {Promise<NotifyAddressEntity>}
     */
    async createAddress (createAddressDto) {
        const { data } = await this.http.post('/', createAddressDto)
        return new NotifyAddressEntity(data)
    }
}

export const notifyAddressesApi = new NotifyApi('/api/notify/addresses')
