import { NotifyTriggerEntity } from './entities/NotifyTriggerEntity'
import { UpdateMultipleApi } from './UpdateMultipleApi'

class NotifyTriggersApi extends UpdateMultipleApi {
    Entity = NotifyTriggerEntity

    /**
     * @param useCache {boolean}
     * @returns {Promise<NotifyTriggerEntity[]>}
     */
    async getTriggers (useCache = false) {
        const { data } = await this.http.get('/', { cache: useCache })
        return data.map(c => new NotifyTriggerEntity(c))
    }

    /**
     * @param createTriggerDto {CreateTriggerDto}
     * @returns {Promise<NotifyTriggerEntity>}
     */
    async createTrigger (createTriggerDto) {
        const { data } = await this.http.post('/', createTriggerDto)
        return new NotifyTriggerEntity(data)
    }
}

export const notifyTriggersApi = new NotifyTriggersApi('/api/notify/triggers')
