import { BaseApi } from './BaseApi'
import { NsiLpu, NsiMkb, NsiVidmp, NsiMedProfile } from './entities/NsiEntities'
import { NsiTaskEntity } from './entities/NsiTaskEntity'

class NsiApi extends BaseApi {
    async getLpu ({ lpuSearch, limit, offset, scoreId } = {}) {
        const { data } = await this.http.get('/lpu', {
            params: {
                lpuSearch, limit, offset, scoreId
            }
        })

        return data.map(c => new NsiLpu(c))
    }

    async getMkb ({ mkbSearch, onlyMkbCode, parentId, scoreId } = {}) {
        const { data } = await this.http.get('/mkb', {
            params: {
                mkbSearch, onlyMkbCode, parentId, scoreId
            }
        })
        return data.map(d => new NsiMkb(d))
    }

    async getVidmp ({ scoreId } = {}) {
        const { data } = await this.http.get('/vidmp', {
            params: {
                scoreId
            }
        })

        return data.map(e => new NsiVidmp(e))
    }

    async getMedProfile ({ scoreId } = {}) {
        const { data } = await this.http.get('/med-profile', {
            params: {
                scoreId
            }
        })

        return data.map(e => new NsiMedProfile(e))
    }

    /**
     * @return {Promise<NsiTaskEntity>}
     */
    async getNsiTask (useCache = false) {
        const { data } = await this.http.get('/sync', { cache: useCache })
        return new NsiTaskEntity(data)
    }

    /**
     * @param update {UpdateNsiTaskDto}
     * @return {Promise<NsiTaskEntity>}
     */
    async updateNsiTask (update) {
        const { data } = await this.http.patch('/sync', update)
        return new NsiTaskEntity(data)
    }

    /**
     * @return {Promise<void>}
     */
    async startNsiTaskNow () {
        await this.http.post('/sync/send-now')
    }
}

export const nsiApi = new NsiApi('/api/nsi')
