import { ReportEntity } from './entities/ReportEntity'
import { ListResponseEntity } from './entities/ListResponseEntity'
import { ReportDataItem } from './entities/ReportDataItem'
import { UpdateMultipleApi } from './UpdateMultipleApi'

class ReportsApi extends UpdateMultipleApi {
    Entity = ReportEntity

    /**
     * @async
     * @returns {ListResponseEntity<ReportEntity>}
     */
    async getAll ({ createDateFrom, createDateTo, periodDateFrom, periodDateTo, reportName, scoreId, type, offset, limit } = {}, useCache = false) {
        const { data } = await this.http.get(
            '/', {
                params: {
                    createDateFrom,
                    createDateTo,
                    periodDateFrom,
                    periodDateTo,
                    reportName,
                    scoreId,
                    type,
                    offset,
                    limit
                },
                cache: useCache
            })
        const { items, total } = data
        return new ListResponseEntity(items.map(i => new this.Entity(i)), total)
    }

    /**
     * @async
     * @param id {string}
     * @param sort {SortType}
     * @returns {Promise<ReportDataItem[]>}
     */
    async getData (id, sort) {
        const { data } = await this.http.get(`/${id}/data?sort=${sort}`)

        return data.map(i => new ReportDataItem(i))
    }

    /**
     * @async
     * @param report {Object}
     * @return {Promise<ReportEntity>}
     */
    async create (report) {
        const { data } = await this.http.post(`/`, report)
        return new this.Entity(data)
    }
}

export const reportsApi = new ReportsApi('/api/reports')
