import { ScoreEntity } from './entities/ScoreEntity'
import { ListResponseEntity } from './entities/ListResponseEntity'
import { UpdateMultipleApi } from './UpdateMultipleApi'

class ScoresApi extends UpdateMultipleApi {
    Entity = ScoreEntity

    /**
     * /**
     * @async
     * @param filterOptions {Object}
     * @param useCache {Boolean}
     * @return {Promise<ListResponseEntity<ScoreEntity>>}
     */
    async getScores (filterOptions = {}, useCache = false) {
        const { data } = await this.http.get('/', {
            params: filterOptions,
            cache: useCache
        })
        const { items, total } = data
        return new ListResponseEntity(items.map(i => new this.Entity(i)), total)
    }

    /**
     * @async
     * @param id {string}
     * @return {Promise<ScoreEntity>}
     */
    async getScore (id) {
        const { data } = await this.http.get(`/${id}`)
        return new this.Entity(data)
    }

    /**
     * @param scoreId {string}
     * @returns {Promise<ScoreEntity>}
     */
    async sendScore (scoreId) {
        const { data } = await this.http.post(`/${scoreId}/send`)
        return new this.Entity(data)
    }
}

export const scoresApi = new ScoresApi('/api/scores')
