import { BaseApi } from './BaseApi'
import SupervisingEntity, { ThresholdsEntity } from './entities/SupervisingEntity'

class SupervisingApi extends BaseApi {
    /**
     * @async
     * @returns {SupervisingEntity}
     */
    async getAll () {
        const { data } = await this.http.get('/')
        return new SupervisingEntity(data)
    }

    /**
     * @async
     * @param data {ThresholdsUpdateDto}
     * @return {ThresholdsEntity}
     */
    async updateThresholds (data) {
        const response = await this.http.patch('/thresholds', data)
        return new ThresholdsEntity(response.data)
    }
}

export const supervisingApi = new SupervisingApi('/api/supervising')
