import { BaseApi } from './BaseApi'
import { SyncDataTaskEntity } from './entities/SyncDataTaskEntity'

class SyncDataApi extends BaseApi {
    /**
     * @return {Promise<SyncDataTaskEntity>}
     */
    async get (useCache = false) {
        const { data } = await this.http.get('/', { cache: useCache })
        return new SyncDataTaskEntity(data)
    }

    /**
     * @param update {UpdateSyncDataTaskDto}
     * @return {Promise<SyncDataTaskEntity>}
     */
    async update (update) {
        const { data } = await this.http.patch('/', update)
        return new SyncDataTaskEntity(data)
    }

    /**
     * @return {Promise<void>}
     */
    async startNow () {
        await this.http.post('/now')
    }

    /**
     * @return {Promise<void>}
     */
    async interrupt () {
        await this.http.post('/interrupt')
    }
}

export const syncDataApi = new SyncDataApi('/api/data-sync')
