import { BaseApi } from './BaseApi'
import { ListResponseEntity } from './entities/ListResponseEntity'
import { LogEntity } from './entities/LogEntity'
import { VersionEntity } from './entities/VersionEntity'
import { ParamValue } from './entities/ParamValue'

class SystemApi extends BaseApi {
    /**
     * @async
     * @param selectAll {Boolean}
     * @param taskId {string}
     * @param userId {string}
     * @param limit {Number}
     * @param offset {Number}
     * @param useCache {Boolean=}
     * @return {Promise<ListResponseEntity>}
     */
    async getLog ({ selectAll = false, taskId = null, userId = null, limit, offset }, useCache = false) {
        const { data } = await this.http.get(`/log`, {
            params: {
                selectAll,
                taskId,
                userId,
                limit,
                offset
            },
            cache: useCache
        })

        return new ListResponseEntity(data.items.map(i => new LogEntity(i)), data.total)
    }

    /**
     * @async
     * @return {Promise<VersionEntity>}
     */
    async getVersion () {
        const { data } = await this.http.get(`/version`)

        return new VersionEntity(data)
    }

    /**
     * @async
     * @param useCache {Boolean}
     * @return {Promise<ParamValue[]>}
     */
    async getXGB (useCache = false) {
        const { data } = await this.http.get('/xgb', { cache: useCache })
        const { items } = data
        return items.map(p => new ParamValue(p))
    }
}

export const systemApi = new SystemApi('/api/system')
