import { BaseApi } from './BaseApi'
import { SyncInfo } from './entities/SyncInfo'

class TaskApi extends BaseApi {
    /**
     *
     * @param taskId {string}
     * @return {Promise<void>}
     */
    async runNow (taskId) {
        await this.http.post(`/${taskId}/start-now`)
    }

    /**
     *
     * @returns {Promise<SyncInfo[]>}
     */
    async getSyncQueue () {
        const { data } = await this.http.get('/sync-queue')
        return data.map(item => new SyncInfo(item))
    }
}

export const taskApi = new TaskApi('/api/tasks')
