import { ModelTaskEntity } from './entities/ModelTaskEntity'
import { UpdateMultipleApi } from './UpdateMultipleApi'

class TaskModelApi extends UpdateMultipleApi {
    Entity = ModelTaskEntity

    /**
     * @async
     * @param filterOptions
     * @param useCache {Boolean}
     * @return {Promise<ModelTaskEntity[]>}
     */
    async getAll (filterOptions = {}, useCache = false) {
        const { data } = await this.http.get('/', {
            params: filterOptions,
            cache: useCache
        })
        return data.map(t => new this.Entity(t))
    }

    /**
     * @deprecated
     * @async
     * @param modelTask {Object}
     * @return {Promise<ModelTaskEntity>}
     */
    async create (modelTask) {
        const { data } = await this.http.post('/', modelTask)
        return new this.Entity(data)
    }

    /**
     * @async
     * @param simpleModelTask {SimpleTaskModelCreateDto}
     * @returns {Promise<ModelTaskEntity>}
     */
    async createSimple (simpleModelTask) {
        const { data } = await this.http.post('/simple', simpleModelTask)
        return new this.Entity(data)
    }

    /**
     * @async
     * @param periodicModelTask {PeriodicTaskModelCreateDto}
     * @returns {Promise<ModelTaskEntity>}
     */
    async createPeriodic (periodicModelTask) {
        const { data } = await this.http.post('/periodic', periodicModelTask)
        return new this.Entity(data)
    }

    /**
     * @async
     * @param simpleModelTask {SimpleTaskModelUpdateDto}
     * @returns {Promise<ModelTaskEntity>}
     */
    async updateSimple (simpleModelTask) {
        const { data } = await this.http.patch('/simple', simpleModelTask)
        return new this.Entity(data)
    }

    /**
     * @async
     * @param periodicModelTask {PeriodicTaskModelUpdateDto}
     * @returns {Promise<ModelTaskEntity>}
     */
    async updatePeriodic (periodicModelTask) {
        const { data } = await this.http.patch('/periodic', periodicModelTask)
        return new this.Entity(data)
    }

    /**
     * @async
     * @param id {string}
     * @returns {Promise<void>}
     */
    async interrupt (id) {
        await this.http.post(`/${id}/interrupt`)
    }
}

export const taskModelApi = new TaskModelApi('/api/tasks/models')
