import { ScoreTaskEntity } from './entities/ScoreTaskEntity'
import { UpdateMultipleApi } from './UpdateMultipleApi'

class TaskScoreApi extends UpdateMultipleApi {
    Entity = ScoreTaskEntity

    /**
     * @async
     * @param filterOptions
     * @param useCache {Boolean}
     * @return {Promise<ScoreTaskEntity[]>}
     */
    async getAll (filterOptions = {}, useCache = false) {
        const { data } = await this.http.get('/', {
            params: filterOptions,
            cache: useCache
        })
        return data.map(t => new this.Entity(t))
    }

    /**
     * @deprecated
     * @async
     * @param scoreTask {Object}
     * @return {Promise<ScoreTaskEntity>}
     */
    async create (scoreTask) {
        const { data } = await this.http.post('/', scoreTask)
        return new this.Entity(data)
    }

    /**
     * @async
     * @param simpleScoreTask {SimpleTaskScoreCreateDto}
     * @returns {Promise<ScoreTaskEntity>}
     */
    async createSimple (simpleScoreTask) {
        const { data } = await this.http.post('/simple', simpleScoreTask)
        return new this.Entity(data)
    }

    /**
     * @async
     * @param periodicScoreTask {PeriodicTaskScoreCreateDto}
     * @returns {Promise<ScoreTaskEntity>}
     */
    async createPeriodic (periodicScoreTask) {
        const { data } = await this.http.post('/periodic', periodicScoreTask)
        return new this.Entity(data)
    }

    /**
     * @async
     * @param simpleScoreTask {SimpleTaskModelUpdateDto}
     * @returns {Promise<ScoreTaskEntity>}
     */
    async updateSimple (simpleScoreTask) {
        const { data } = await this.http.patch('/simple', simpleScoreTask)
        return new this.Entity(data)
    }

    /**
     * @async
     * @param periodicScoreTask {PeriodicTaskModelUpdateDto}
     * @returns {Promise<ScoreTaskEntity>}
     */
    async updatePeriodic (periodicScoreTask) {
        const { data } = await this.http.patch('/periodic', periodicScoreTask)
        return new this.Entity(data)
    }

    /**
     * @async
     * @param id {string}
     * @returns {Promise<void>}
     */
    async interrupt (id) {
        await this.http.post(`/${id}/interrupt`)
    }
}

export const taskScoreApi = new TaskScoreApi('/api/tasks/scores')
