import { BaseApi } from './BaseApi'
import { ApiError } from './entities/ApiError'

export class UpdateMultipleApi extends BaseApi {
    /**
     * @async
     * @param updatesRequest {BaseEntity[]}
     * @param deletesRequest {string[]}
     * @param forceDelete {boolean}
     * @return {Promise<void>} todo
     */
    async updateMultiple (updatesRequest = [], deletesRequest = [], forceDelete = false) {
        const { data } = await this.http.patch('/update-multiple', {
            updates: updatesRequest,
            deletes: deletesRequest,
            forceDelete
        })

        data.updates = data.updates.map(u => new this.Entity(u))

        return data
    }

    /**
     * @async
     * @param baseEntity {BaseEntity}
     * @returns {BaseEntity}
     */
    async update (baseEntity) {
        const { updates, errors } = await this.updateMultiple([baseEntity])

        if (updates.length > 0) return updates[0]

        throw ApiError.fromJson(errors[baseEntity.id])
    }

    /**
     * @async
     * @param ids {string[]}
     * @param force {boolean}
     */
    async delete (ids, force = false) {
        return this.updateMultiple([], ids, force)
    }
}
