import UserEntity, { CurrentUserEntity } from './entities/UserEntity'
import { ListResponseEntity } from './entities/ListResponseEntity'
import { UpdateMultipleApi } from './UpdateMultipleApi'

class UsersApi extends UpdateMultipleApi {
    Entity = UserEntity

    /**
     * @async
     * @return {Promise<CurrentUserEntity>}
     */
    async getCurrent () {
        const { data } = await this.http.get('/current')
        return new CurrentUserEntity(data)
    }

    /**
     * @async
     * @param id {string}
     * @returns {UserEntity}
     */
    async get (id) {
        const { data } = this.http.get(`/${id}`)
        return new this.Entity(data)
    }

    /**
     * @async
     * @param useCache {Boolean}
     * @returns {ListResponseEntity<UserEntity>}
     */
    async getAll (useCache = false) {
        const { data } = await this.http.get('/', { cache: useCache })
        const { items, total } = data
        return new ListResponseEntity(items.map(u => new this.Entity(u)), total)
    }

    /**
     * @async
     * @param ids {string[]}
     * @return {Promise<void>}
     */
    async delete (ids) {
        throw Error('Can not delete users')
    }
}

export const usersApi = new UsersApi('/api/users')
