export class CreateAddressDto {
    /**
     * @param name {string}
     * @param email {string}
     * @param triggers {string[]}
     */
    constructor (name, email, triggers) {
        this.name = name
        this.email = email
        this.triggers = triggers
    }
}

export class UpdateAddressDto {
    /**
     * @param name {?string}
     * @param email {?string}
     * @param triggers {?string[]}
     */
    constructor ({ name, email, triggers }) {
        this.name = name
        this.email = email
        this.triggers = [...triggers]
    }
}

export class CreateTriggerDto {
    constructor (type, name, emissionInterval, threshold, subject, messageTemplate) {
        this.type = type
        this.name = name
        this.emissionInterval = emissionInterval
        this.threshold = threshold
        this.subject = subject
        this.messageTemplate = messageTemplate
    }
}

export class UpdateTriggerDto {
    constructor ({ type, name, emissionInterval, threshold, subject, messageTemplate }) {
        this.type = type
        this.name = name
        this.emissionInterval = emissionInterval
        this.threshold = threshold
        this.subject = subject
        this.messageTemplate = messageTemplate
    }
}
