export class SimpleTaskModelCreateDto {
    constructor ({ name, description, period, isPublic, skipSync }) {
        this.name = name
        this.description = description
        this.period = period
        this.isPublic = isPublic
        this.skipSync = skipSync
    }
}

export class PeriodicTaskModelCreateDto {
    constructor ({ name, description, isEnabled, periodDuration, isPublic, nextDateTime, skipSync }) {
        this.name = name
        this.description = description
        this.isEnabled = isEnabled
        this.periodDuration = periodDuration
        this.isPublic = isPublic
        this.nextDateTime = nextDateTime
        this.skipSync = skipSync
    }
}

export class SimpleTaskScoreCreateDto extends SimpleTaskModelCreateDto {
    constructor ({ modelId, ...other }) {
        super(other)
        this.modelId = modelId
    }
}

export class PeriodicTaskScoreCreateDto extends PeriodicTaskModelCreateDto {
    constructor ({ taskModelId, runChildTask, ...other }) {
        super(other)
        this.taskModelId = taskModelId
        this.runChildTask = runChildTask
    }
}
