export class SimpleTaskModelUpdateDto {
    constructor ({ id, name, description, isPublic, period, skipSync }) {
        this.id = id
        this.name = name
        this.description = description
        this.isPublic = isPublic
        this.period = period
        this.skipSync = skipSync
    }
}

export class PeriodicTaskModelUpdateDto {
    constructor ({ id, name, description, isPublic, isEnabled, periodDuration, nextDateTime, skipSync }) {
        this.id = id
        this.name = name
        this.description = description
        this.isPublic = isPublic
        this.isEnabled = isEnabled
        this.periodDuration = periodDuration
        this.nextDateTime = nextDateTime
        this.skipSync = skipSync
    }
}

export class SimpleTaskScoreUpdateDto extends SimpleTaskModelUpdateDto {
    constructor ({ modelId, ...other }) {
        super(other)
        this.modelId = modelId
    }
}

export class PeriodicTaskScoreUpdateDto extends PeriodicTaskModelUpdateDto {
    constructor ({ taskModelId, runChildTask, ...other }) {
        super(other)
        this.taskModelId = taskModelId
        this.runChildTask = runChildTask
    }
}
