import { BaseEntity, notNull } from './BaseEntity'

export class AuthTokenEntity extends BaseEntity {
    constructor ({ secret, userAgent, clientIp, createdAt, lastActive, ...other }) {
        super(secret, other)
        this.secret = notNull(secret)
        this.userAgent = userAgent
        this.clientIp = clientIp
        this.createdAt = createdAt ? new Date(createdAt) : null
        this.lastActive = lastActive ? new Date(lastActive) : null
    }
}
