const throwOrWarn = msg => {
    const e = new Error(msg)

    if (process.env.NODE_ENV !== 'production') throw e
    /* eslint-disable no-console */
    console.warn(e)
}

export const notNull = (value, field) => {
    if (value === null || value === undefined) {
        throwOrWarn(`Field ${field} mark with 'notNull', but null or undefined was found`)
    }
    return value
}

export const fromEnum = (value, enumObject, _notNull, field) => {
    if (_notNull) notNull(value, field)
    if (value === null || value === undefined) return value
    const values = Object.values(enumObject)
    if (!values.includes(value)) {
        throwOrWarn(`Field ${field} must be one of values [${values}], but '${value}' was found`)
    }
    return value
}

/**
 * @param other {Object}
 */
export const checkExtra = other => {
    if (other) {
        const keys = Object.keys(other)
        if (keys.length) {
            throwOrWarn(`Extra keys found: ${keys}`)
        }
    }
}

export class BaseEntity {
    constructor (id, other) {
        checkExtra(other)
        this.id = notNull(id, 'id')
    }
}
