import { BaseEntity, notNull } from './BaseEntity'

export default class GroupEntity extends BaseEntity {
    constructor ({ id, name, users, zones, isDefault, ...other }) {
        super(id, other)
        this.name = notNull(name, 'name')
        this.usersCount = notNull(users, 'users')
        this.zones = notNull(zones, 'zones')
        this.isDefault = notNull(isDefault, 'isDefault')
    }
}

export const Zones = {
    learn: 'learn',
    apply: 'apply',
    reports: 'reports',
    reportsFed: 'reportsFed',
    supervising: 'supervising'
}

export const ZonesTranslation = {
    [Zones.learn]: 'Обучение',
    [Zones.apply]: 'Применение',
    [Zones.reports]: 'Отчеты',
    [Zones.reportsFed]: 'Отчеты в ФФОМС',
    [Zones.supervising]: 'Мониторинг'
}

export const ZonesList = [Zones.learn, Zones.apply, Zones.reports, Zones.reportsFed, Zones.supervising]

export const ZoneValues = {
    NONE: 'NONE',
    READ: 'READ',
    WRITE: 'WRITE'
}

export const ZoneValuesTranslation = {
    [ZoneValues.NONE]: 'Нет доступа',
    [ZoneValues.READ]: 'Просмотр',
    [ZoneValues.WRITE]: 'Изменение'
}

export const ZoneValuesOptions = [
    { id: ZoneValues.NONE, value: ZoneValuesTranslation[ZoneValues.NONE] },
    { id: ZoneValues.READ, value: ZoneValuesTranslation[ZoneValues.READ] },
    { id: ZoneValues.WRITE, value: ZoneValuesTranslation[ZoneValues.WRITE] }
]

export const SupervisingZoneValuesOptions = [
    { id: ZoneValues.NONE, value: ZoneValuesTranslation[ZoneValues.NONE] },
    { id: ZoneValues.READ, value: ZoneValuesTranslation[ZoneValues.READ] }
]
