import { notNull } from './BaseEntity'
import { PeriodicEntity } from './PeriodicEntity'

export const ModelStatus = {
    UNDEFINED: 'UNDEFINED',
    LEARNING: 'LEARNING',
    SUCCESS: 'SUCCESS',
    FAILED: 'FAILED'
}

export const ModelStatusTranslation = {
    [ModelStatus.UNDEFINED]: 'Неизвестно',
    [ModelStatus.LEARNING]: 'Обучается',
    [ModelStatus.SUCCESS]: 'Успешно завершено',
    [ModelStatus.FAILED]: 'Завершено с ошибкой'
}

export const ModelStatusSelection = [ModelStatus.UNDEFINED, ModelStatus.LEARNING, ModelStatus.SUCCESS, ModelStatus.FAILED]
    .map(s => ({ id: s, name: ModelStatusTranslation[s] }))

export class ModelEntity extends PeriodicEntity {
    constructor ({ id, createDate, description, name, userId, progress, isPublic, rowsOutdated, isPeriodic, isArchive, taskId, ...other }) {
        // rowsOutdated - лишнее
        super(id, other)
        this.name = name
        this.description = notNull(description, 'description')
        this.isPublic = Boolean(notNull(isPublic, 'isPublic'))
        this.createDate = createDate ? new Date(createDate) : null
        this.userId = userId || null
        this.isPeriodic = notNull(isPeriodic, 'isPeriodic')
        this.isArchive = notNull(isArchive, 'isArchive')
        this.taskId = notNull(taskId, 'taskId')
    }
}
