import { BaseEntity, fromEnum, notNull } from './BaseEntity'

export const TriggerType = {
    cpu: 'cpu',
    ram: 'ram',
    hdd: 'hdd',
    cputmp: 'cputmp',
    evlog: 'evlog',
    foms: 'foms'
}

export const TriggerTypeMeasures = {
    percent: 'percent',
    degree: 'degree ',
    boolean: 'boolean'
}

export const TriggerTypeToMeasures = {
    [TriggerType.cpu]: TriggerTypeMeasures.percent,
    [TriggerType.ram]: TriggerTypeMeasures.percent,
    [TriggerType.hdd]: TriggerTypeMeasures.percent,
    [TriggerType.cputmp]: TriggerTypeMeasures.degree,
    [TriggerType.evlog]: TriggerTypeMeasures.boolean,
    [TriggerType.foms]: TriggerTypeMeasures.boolean
}

export const TriggerTypeTranslation = {
    [TriggerType.cpu]: 'ЦП',
    [TriggerType.ram]: 'ОЗУ',
    [TriggerType.hdd]: 'ЖД',
    [TriggerType.cputmp]: 'Температура ЦП',
    [TriggerType.evlog]: 'Ошибки логирования',
    [TriggerType.foms]: 'Подключение к АИС ТФОМС'
}

export const TriggerTypeSelection = [TriggerType.cpu, TriggerType.ram, TriggerType.hdd, TriggerType.cputmp, TriggerType.evlog, TriggerType.foms]
    .map(t => ({ id: t, name: TriggerTypeTranslation[t] }))

export class NotifyTriggerEntity extends BaseEntity {
    constructor ({ id, name, type, threshold, emissionInterval, subject, messageTemplate, ...other }) {
        super(id, other)
        this.id = notNull(id, 'id')
        this.name = notNull(name, 'name')
        this.type = fromEnum(type, TriggerType, true, 'type')
        this.threshold = notNull(threshold, 'threshold')
        this.emissionInterval = notNull(emissionInterval, 'emissionInterval')
        this.subject = notNull(subject, 'subject')
        this.messageTemplate = notNull(messageTemplate, 'messageTemplate')
    }
}
