import { BaseEntity, fromEnum, notNull } from './BaseEntity'
import { TaskExecStatus } from './BaseTaskEntity'

export class NsiTaskEntity extends BaseEntity {
    constructor ({ taskId, taskExecStatus, nextDateTime, runDateTime, inProgress, isEnabled, attemptInterval, attemptLimit, ...other }) {
        super(taskId, other)
        this.taskId = notNull(taskId, 'taskId')
        this.taskExecStatus = fromEnum(taskExecStatus, TaskExecStatus, true, 'taskExecStatus')
        this.nextDateTime = notNull(nextDateTime, 'nextDateTime')
        this.runDateTime = notNull(runDateTime, 'runDateTime')
        this.inProgress = notNull(inProgress, 'inProgress')
        this.isEnabled = notNull(isEnabled, 'isEnabled')
        this.attemptInterval = notNull(attemptInterval, 'attemptInterval')
        this.attemptLimit = notNull(attemptLimit, 'attemptLimit')
    }
}
