import { dateFilter } from 'src/utils/filters'
import { BaseEntity } from './BaseEntity'
import { StrictPeriod } from './Periods'

export class PeriodicEntity extends BaseEntity {
    constructor (id, { period, periodReal, ...other }) {
        // periodReal - Павел сказал, что нам это не надо (тогда что оно тут делает??)
        super(id, other)
        this.period = StrictPeriod.fromJson(period)
    }

    get periodText () {
        return dateFilter(this.period.begin) + ' - ' + dateFilter(this.period.end)
    }
}
