import { notNull } from './BaseEntity'

export class Period {
    constructor (begin, end) {
        this.begin = begin
        this.end = end
    }

    copy () {
        return new Period(this.begin, this.end)
    }

    static fromJson ({ begin, end }) {
        return new Period(
            begin ? new Date(begin) : null,
            end ? new Date(end) : null
        )
    }
}

export class StrictPeriod {
    constructor (begin, end) {
        this.begin = notNull(begin, 'begin')
        this.end = notNull(end, 'end')
    }

    copy () {
        return new StrictPeriod(this.begin, this.end)
    }

    static fromJson ({ begin, end }) {
        return new StrictPeriod(
            begin ? new Date(begin) : null,
            end ? new Date(end) : null
        )
    }
}
