import { fromEnum, notNull } from './BaseEntity'
import { PeriodicEntity } from './PeriodicEntity'

export const ScoreStatus = {
    UNDEFINED: 'UNDEFINED',
    SCORE_CALC: 'SCORE_CALC',
    SUCCESS: 'SUCCESS',
    FAILED: 'FAILED'
}

export const ScoreStatusTranslation = {
    [ScoreStatus.UNDEFINED]: 'Неизвестно',
    [ScoreStatus.SCORE_CALC]: 'Вычисляется',
    [ScoreStatus.SUCCESS]: 'Успешно завершено',
    [ScoreStatus.FAILED]: 'Завершено с ошибкой'
}

export const ScoreStatusSelection = [ScoreStatus.UNDEFINED, ScoreStatus.SCORE_CALC, ScoreStatus.SUCCESS, ScoreStatus.FAILED]
    .map(s => ({ id: s, name: ScoreStatusTranslation[s] }))

export const SendStatus = {
    UNDEFINED: 'UNDEFINED',
    CREATED: 'CREATED',
    NeedSend: 'NeedSend',
    IsSent: 'IsSent'
}

export const SendStatusTranslation = {
    [SendStatus.UNDEFINED]: 'Неизвестно',
    [SendStatus.CREATED]: 'Не отправлена',
    [SendStatus.NeedSend]: 'Ожидает отправки',
    [SendStatus.IsSent]: 'Отправлена'
}

export class ScoreEntity extends PeriodicEntity {
    constructor ({ id, name, userId, sendStatus, createDate, description, modelId, modelName, progress, isPublic, taskId, taskName, isPeriodic, isArchive, ...other }) {
        super(id, other)
        this.taskId = taskId
        this.taskName = taskName
        this.modelId = modelId
        this.modelName = modelName
        this.userId = notNull(userId, 'userId')
        this.name = notNull(name, 'name')
        this.description = notNull(description, 'description')
        this.isPublic = notNull(isPublic, 'isPublic')
        this.createDate = createDate ? new Date(createDate) : null
        this.sendStatus = fromEnum(sendStatus, SendStatus, true, 'sendStatus')
        this.isPeriodic = notNull(isPeriodic, 'isPeriodic')
        this.isArchive = notNull(isArchive, 'isArchive')
    }
}
