import { BaseEntity, notNull } from './BaseEntity'

export const SuperviseColors = {
    RED: '#dc3545',
    YELLOW: '#ffc107',
    GREEN: '#28a745'
}

class SupervisingHardItem {
    constructor ({ process, system, total }) {
        this.process = notNull(process, 'process')
        this.system = notNull(system, 'system')
        this.total = notNull(total, 'total')
    }

    get percent () {
        return this.total !== 0 ? this.system / this.total : 1
    }
}

class HardwareEntity {
    constructor ({ cpu, hdd, ram, cpuMaxCoreTemp, nthreads, pid, processName }) {
        this.cpu = new SupervisingHardItem(notNull(cpu, 'cpu'))
        this.hdd = new SupervisingHardItem(notNull(hdd, 'hdd'))
        this.ram = new SupervisingHardItem(notNull(ram, 'ram'))
        this.cpuMaxCoreTemp = notNull(cpuMaxCoreTemp, 'cpuMaxCoreTemp')
        this.nthreads = notNull(nthreads, 'nthreads')
        this.pid = notNull(pid, 'pid')
        this.processName = notNull(processName, 'processName')
    }
}

class SupervisingSoftItem {
    constructor ({ modelCount, scoreCount, reportCount }) {
        this.modelCount = notNull(modelCount, 'modelCount')
        this.scoreCount = notNull(scoreCount, 'scoreCount')
        this.reportCount = notNull(reportCount, 'reportCount')
    }
}

class SoftwareEntity {
    constructor ({ inWork, inDeferred, errorCount, activeUserCount, fomsIsActive }) {
        this.inWork = new SupervisingSoftItem(notNull(inWork, 'inWork'))
        this.inDeferred = new SupervisingSoftItem(notNull(inDeferred, 'inDeferred'))
        this.errorCount = notNull(errorCount, 'errorCount')
        this.activeUserCount = notNull(activeUserCount, 'activeUserCount')
        this.fomsIsActive = notNull(fomsIsActive, 'fomsIsActive')
    }
}

class ThresholdEntity {
    constructor ({ warn, crit }) {
        this.warn = notNull(warn, 'warn')
        this.crit = notNull(crit, 'crit')
    }

    colorFor (value) {
        if (value > this.crit) return SuperviseColors.RED
        if (value > this.warn) return SuperviseColors.YELLOW
        return SuperviseColors.GREEN
    }
}

export class ThresholdsEntity {
    constructor ({ cpu, ram, hdd, cputmp }) {
        this.cpu = new ThresholdEntity(notNull(cpu, 'cpu'))
        this.ram = new ThresholdEntity(notNull(ram, 'ram'))
        this.hdd = new ThresholdEntity(notNull(hdd, 'hdd'))
        this.cputmp = new ThresholdEntity(notNull(cputmp, 'cputmp'))
    }
}

export default class SupervisingEntity extends BaseEntity {
    constructor ({ hardware, software, thresholds, ...other }) {
        super('fixme', other) // fixme
        this.hardware = new HardwareEntity(notNull(hardware, 'hardware'))
        this.software = new SoftwareEntity(notNull(software, 'software'))
        this.thresholds = new ThresholdsEntity(notNull(thresholds, 'thresholds'))
    }
}
