import { BaseEntity, fromEnum, notNull } from './BaseEntity'
import { TaskExecStatus } from './BaseTaskEntity'

export class SyncDataTaskEntity extends BaseEntity {
    constructor ({ taskId, execStatus, runDateTime, nextDateTime, isEnabled, attemptInterval, attemptLimit, periodDuration, current, total, ...other }) {
        super(taskId, other)
        this.taskId = notNull(taskId, 'taskId')
        this.execStatus = fromEnum(execStatus, TaskExecStatus, true, 'execStatus')
        this.runDateTime = notNull(runDateTime, 'runDateTime')
        this.nextDateTime = notNull(nextDateTime, 'nextDateTime')
        this.isEnabled = notNull(isEnabled, 'isEnabled')
        this.attemptInterval = notNull(attemptInterval, 'attemptInterval')
        this.attemptLimit = notNull(attemptLimit, 'attemptLimit')
        this.periodDuration = notNull(periodDuration, 'periodDuration')
        this.current = notNull(current, 'current')
        this.total = notNull(total, 'total')
    }

    get progress () {
        return this.current / Math.max(1, this.total) * 100
    }
}
