import { BaseEntity, fromEnum, notNull } from './BaseEntity'
import { TaskType } from './BaseTaskEntity'

export class SyncInfo extends BaseEntity {
    constructor ({ taskId, userId, taskName, taskType, syncStatus, current, total, ...others }) {
        super(taskId, others)
        this.taskId = notNull(taskId, 'taskId')
        this.userId = userId
        this.taskName = notNull(taskName, 'taskName')
        this.taskType = fromEnum(taskType, TaskType, true, 'taskType')
        this.syncStatus = notNull(syncStatus, 'syncStatus')
        this.current = notNull(current, 'current')
        this.total = notNull(total, 'total')
    }

    /**
     * Процент прогресса, с учетом крайних ситуаций
     * @return {number}
     */
    get progress () {
        if (this.syncStatus) {
            return this.total !== 0 ? Math.round(100 * this.current / this.total) : 0
        }
        return 0
    }
}
