import { BaseEntity, notNull } from './BaseEntity'

export class TaskContentCreateEntity extends BaseEntity {
    constructor ({ taskId, taskType, content, userId, ...other }) {
        super(content.id, other)
        this.taskId = notNull(taskId, 'taskId')
        this.taskType = notNull(taskType, 'taskType')
        this.content = notNull(content, 'content')
        this.userId = userId || null
    }
}
