import { BaseEntity, fromEnum, notNull } from './BaseEntity'
import { TaskExecStatus } from './BaseTaskEntity'

// fixme id
export class TaskProgressEntity extends BaseEntity {
    constructor ({ taskType, taskId, description, name, execStatus, createDate, progressCurrent, progressTotal, waitPosition, ...other }) {
        taskId = notNull(taskId, 'notNull')
        super(taskId, other)
        this.taskId = taskId
        this.taskType = notNull(taskType, 'taskType')
        this.description = notNull(description, 'description')
        this.name = notNull(name, 'name')
        this.execStatus = fromEnum(execStatus, TaskExecStatus, true, 'execStatus')
        this.createDate = notNull(createDate, 'createDate')
        this.progressCurrent = notNull(progressCurrent, 'progressCurrent')
        this.progressTotal = notNull(progressTotal, 'progressTotal')
        this.waitPosition = notNull(waitPosition, 'waitPosition')
    }
}
