import { BaseEntity, notNull } from './BaseEntity'
import GroupEntity from './GroupEntity'

export default class UserEntity extends BaseEntity {
    constructor ({ id, login, fullName, isActive, groupId, isAdmin, lastActive, isValid, ...other }) {
        super(id, other)
        this.login = notNull(login, 'login')
        this.fullName = notNull(fullName, 'fullName')
        this.groupId = groupId
        this.isActive = Boolean(notNull(isActive, 'isActive'))
        this.isAdmin = Boolean(notNull(isAdmin, 'isAdmin'))
        this.isValid = notNull(isValid, 'isValid')
        this.lastActive = lastActive ? new Date(lastActive) : null
    }
}

// fixme
export class CurrentUserEntity extends UserEntity {
    constructor ({ group, ...other }) {
        const groupId = group !== null ? group.id : 'fixme'
        super({ groupId, ...other })
        this.group = group !== null ? new GroupEntity(group) : null
    }
}
