import Vue from 'vue'
import { bigNumFilter, dateFilter, ellipsisFilter, percentFilter, roundFilter, sizeFilter, lowercase, spaceAfterComma } from './utils/filters'
import VeeValidate from 'vee-validate'

import Notifications from 'vue-notification'

import { DatePicker, TimeSelect, Button, Pagination, Collapse, CollapseItem, Checkbox, Tabs, TabPane, Slider, Input } from 'element-ui'
import lang from 'element-ui/lib/locale/lang/ru-RU'
import locale from 'element-ui/lib/locale'

import UserView from 'src/components/common/UserView'

export default function bootstrap () {
    Vue.config.productionTip = false

    Vue.filter('dateFilter', dateFilter)
    Vue.filter('bigNumFilter', bigNumFilter)
    Vue.filter('percentFilter', percentFilter)
    Vue.filter('roundFilter', roundFilter)
    Vue.filter('ellipsisFilter', ellipsisFilter)
    Vue.filter('sizeFilter', sizeFilter)
    Vue.filter('lowercase', lowercase)
    Vue.filter('spaceAfterComma', spaceAfterComma)

    Vue.use(VeeValidate)

    Vue.use(Notifications)

    // element ui
    locale.use(lang)
    Vue.component(DatePicker.name, DatePicker)
    Vue.component(TimeSelect.name, TimeSelect)
    Vue.component(Button.name, Button)
    Vue.component(Pagination.name, Pagination)
    Vue.component(Collapse.name, Collapse)
    Vue.component(CollapseItem.name, CollapseItem)
    Vue.component(Checkbox.name, Checkbox)
    Vue.component(Tabs.name, Tabs)
    Vue.component(TabPane.name, TabPane)
    Vue.component(Slider.name, Slider)
    Vue.component(Input.name, Input)

    Vue.component(UserView.name, UserView)
}
