import { mapGetters, mapState } from 'vuex'
import { Zones, ZoneValues } from 'src/api/entities/GroupEntity'

export const ApplyMixin = {
    computed: {
        ...mapState({
            currentUser: state => state.Auth.currentUser
        }),

        ...mapGetters({
            userZones: 'userZones',
            isAdmin: 'isAdmin'
        }),

        canWrite () {
            return this.isAdmin || this.userZones[Zones.apply] === ZoneValues.WRITE
        }
    }
}
