import Vue from 'vue'
import store from 'src/store/store'

export default Vue.component('UserView', {
    functional: true,

    name: 'UserView',

    props: {
        userId: { type: String, required: false },
        notFound: { type: String, required: false, default: 'Имя пользователя не найдено' },
        userIsNull: { type: String, required: false, default: '' }
    },

    render (createElement, context) {
        const elementOptions = {
            ...context.data,
            style: { 'white-space': 'nowrap' }
        }

        if (!context.props.userId) return createElement('span', elementOptions, context.props.userIsNull)

        const user = store.getters['Users/usersById'][context.props.userId]
        return createElement(
            'span',
            elementOptions,
            user
                ? `${user.fullName} (${user.login})`
                : context.props.notFound
        )
    }
})
