import Vue from 'vue'
import App from 'src/App.vue'
import { router } from 'src/router'
import store from 'src/store/store'
import * as types from 'src/store/types'
import bootstrap from './bootstrap'

bootstrap()

// снимет плейсхолдер, который включен по умолчанию
function showApp () {
    document.getElementById('preloader-container').classList.toggle('preloader_active')
    document.getElementById('preloader-placeholder').classList.toggle('preloader_active')

    // важно запустить приложение после получения информации о пользователе,
    //  чтобы в beforeEnter роутов не было гонки со Store
    // eslint-disable-next-line no-new
    new Vue({
        el: '#app',
        store,
        router,
        render: h => h(App)
    })
}

/* eslint-disable no-console */
console.log('ENV:', process.env.NODE_ENV)

// выполним запрос на currentUser
//  + сразу же проверка authData и получение роли пользователя.
store.dispatch(types.startUp)
    .then(showApp)
    .catch(e => {
        console.error(e)
        showApp()
    })
