import * as types from 'src/store/types'

import { authApi, usersApi } from 'src/api'

const getDefaultState = () => {
    return {
        currentUser: null,
        sessions: []
    }
}

/** Авторизация */
export default {
    namespaced: true,

    state: getDefaultState(),

    mutations: {
        setCurrentUser (state, currentUser) {
            state.currentUser = currentUser
        },

        setSessions (state, sessions) {
            state.sessions = sessions
        },

        reset: (state) => Object.assign(state, getDefaultState())
    },

    actions: {
        [types.reset]: ({ commit }) => commit('reset'),

        async [types.getCurrentUser] ({ commit }) {
            try {
                commit('setCurrentUser', await usersApi.getCurrent())
            } catch (e) {
                commit('setCurrentUser', null)
                throw e
            }
        },

        async [types.getUserSessions] ({ commit }) {
            try {
                commit('setSessions', await authApi.getTokens())
            } catch (e) {
                commit('setSessions', [])
                throw e
            }
        },

        async [types.revokeUserSessions] ({ commit }, ids) {
            await authApi.revokeTokens(ids)
            commit('setSessions', await authApi.getTokens())
        },

        async [types.login] ({ dispatch }, { login, password, removeOldTokens }) {
            await authApi.login(login, password, removeOldTokens)
        },

        [types.logout] () {
            return authApi.logout()
        }
    }
}
