import * as types from 'src/store/types'
import { supervisingApi } from 'src/api'

const getDefaultState = () => {
    return {
        loading: true,
        data: null
    }
}

export default {
    namespaced: true,

    state: getDefaultState(),

    mutations: {
        setLoading (state, value) {
            state.loading = value
        },

        setItems (state, data) {
            state.data = data
        },

        setThresholds (state, data) {
            state.data.thresholds = data
        },

        reset: state => Object.assign(state, getDefaultState())
    },

    actions: {
        [types.reset]: ({ commit }) => commit('reset'),

        async [types.getAllSupervising] ({ commit }) {
            try {
                commit('setLoading', true)
                commit('setItems', await supervisingApi.getAll())
            } finally {
                commit('setLoading', false)
            }
        },

        /**
         * @param commit {CallableFunction}
         * @param data {SupervisingEntity}
         * @returns {Promise<void>}
         */
        async [types.setSupervising] ({ commit }, data) {
            commit('setItems', data)
            commit('setLoading', false)
        },

        /**
         * @param commit {CallableFunction}
         * @param data {ThresholdsUpdateDto}
         * @return {Promise<void>}
         */
        async [types.updateSupervisingThresholds] ({ commit }, data) {
            const thresholds = await supervisingApi.updateThresholds(data)
            commit('setThresholds', thresholds)
        }
    }
}
