import * as types from '../types'
import { syncDataApi } from '../../api/SyncDataApi'

const getDefaultState = () => {
    return {
        task: null,
        taskLoading: false,
        taskUpdating: false
    }
}

export default {
    namespaced: true,

    state: getDefaultState(),

    mutations: {
        reset: (state) => Object.assign(state, getDefaultState()),

        /**
         * @param state
         * @param task {SyncDataTaskEntity}
         */
        setTask (state, task) {
            state.task = task
        },

        /**
         * @param state
         * @param progress {TaskProgressEntity}
         */
        updateSyncDataTaskProgressByEvent (state, progress) {
            if (state.task === null) return
            state.task.execStatus = progress.execStatus
            state.task.current = progress.progressCurrent
            state.task.total = progress.progressTotal
        },

        /**
         * @param state
         * @param value {boolean}
         */
        setTaskLoading (state, value) {
            state.taskLoading = value
        },

        /**
         * @param state
         * @param value {boolean}
         */
        setTaskUpdating (state, value) {
            state.taskUpdating = value
        }
    },

    actions: {
        [types.reset]: ({ commit }) => commit('reset'),

        async [types.getSyncDataTask] ({ commit }, useCache) {
            try {
                commit('setTaskLoading', true)
                commit('setTask', await syncDataApi.get(useCache))
            } finally {
                commit('setTaskLoading', false)
            }
        },

        /**
         * @param commit
         * @param data {UpdateSyncDataTaskDto}
         * @return {Promise<void>}
         */
        async [types.updateSyncDataTask] ({ commit }, data) {
            try {
                commit('setTaskUpdating', true)
                commit('setTask', await syncDataApi.update(data))
            } finally {
                commit('setTaskUpdating', false)
            }
        },

        async [types.startSyncDataTaskNow] () {
            await syncDataApi.startNow()
        },

        /**
         * @param commit
         * @param state
         * @param data {TaskProgressEntity}
         * @return {Promise<void>}
         */
        async [types.updateSyncDataTaskProgressByEvent] ({ commit, state }, data) {
            commit('updateSyncDataTaskProgressByEvent', data)
        },

        /**
         * @param commit
         * @returns {Promise<void>}
         */
        async [types.interruptSyncDataTask] ({ commit }) {
            await syncDataApi.interrupt()
        }
    }
}
