import * as types from 'src/store/types'
import { taskApi } from 'src/api/TaskApi'
import { TaskExecStatus } from '../../api/entities/BaseTaskEntity'

const getDefaultState = () => {
    return {
        loading: true,
        queue: []
    }
}

export default {
    namespaced: true,

    state: getDefaultState(),

    mutations: {
        setLoading (state, loading) {
            state.loading = loading
        },

        setQueue (state, modelTasks) {
            state.queue = modelTasks
        },

        /**
         * @param state
         * @param data {TaskProgressEntity}
         */
        updateSyncInfoProgressByEvent (state, data) {
            const index = state.queue.findIndex(t => t.taskId === data.taskId)
            if (index >= 0) {
                const info = state.queue[index]
                if (data.execStatus === TaskExecStatus.WAIT_SYNC) {
                    info.current = data.progressCurrent
                    info.total = data.progressTotal
                    info.syncStatus = data.waitPosition === 0
                } else {
                    state.queue.splice(index, 1)
                }
            }
        },

        reset: (state) => Object.assign(state, getDefaultState())
    },

    actions: {
        [types.reset]: ({ commit }) => commit('reset'),

        async [types.getSyncQueue] ({ commit }) {
            commit('setLoading', true)
            try {
                commit('setQueue', await taskApi.getSyncQueue())
            } finally {
                commit('setLoading', false)
            }
        },

        /**
         * @param commit
         * @param data {TaskProgressEntity}
         * @returns {Promise<void>}
         */
        async [types.updateSyncInfoProgressByEvent] ({ commit }, data) {
            commit('updateSyncInfoProgressByEvent', data)
        }
    }
}
