import * as types from 'src/store/types'
import { usersApi } from 'src/api'
import Vue from 'vue'

const getDefaultState = () => {
    return {
        users: [],
        total: 0,
        loading: true
    }
}

export default {
    namespaced: true,

    state: getDefaultState(),

    getters: {
        usersByLogin: (state) => {
            let result = {}
            for (let u of state.users) {
                result[u.login] = u
            }
            return result
        },

        usersById: (state) => {
            let result = {}
            for (let u of state.users) {
                result[u.id] = u
            }
            return result
        },

        usersSelection: (state) => {
            return state.users.map(u => ({ id: u.id, name: u.login }))
        }
    },

    mutations: {
        setUsers (state, { total, items: users }) {
            state.total = total
            state.users = users
        },

        updateUser (state, user) {
            const idx = state.users.findIndex(u => u.id === user.id)
            if (idx >= 0) Vue.set(state.users, idx, user)
        },

        setLoading (state, loading) {
            state.loading = loading
        },

        reset: (state) => Object.assign(state, getDefaultState())
    },

    actions: {
        [types.reset]: ({ commit }) => commit('reset'),

        async [types.getUser] (context, id) {
            return usersApi.get(id)
        },

        async [types.getAllUsers] ({ commit }, useCache = false) {
            commit('setLoading', true)
            try {
                commit('setUsers', await usersApi.getAll(useCache))
            } finally {
                commit('setLoading', false)
            }
        },

        async [types.updateUser] ({ commit }, user) {
            commit('updateUser', await usersApi.update(user))
        }
    }
}
