function fallbackCopyToClipboard (text) {
    const textArea = document.createElement('textarea')
    textArea.value = text
    document.body.appendChild(textArea)
    textArea.focus()
    textArea.select()

    try {
        return document.execCommand('copy')
    } finally {
        document.body.removeChild(textArea)
    }
}

export async function copyToClipboard (text) {
    try {
        // необходима поддержка в браузере и https
        if (navigator.clipboard) {
            await navigator.clipboard.writeText(text)
            return true
        } else {
            return fallbackCopyToClipboard(text)
        }
    } catch (e) {
        console.error(e)
        return false
    }
}
