/**
 * Способ притормозить вызов cb по срабатыванию некоторых часытх событий.
 * https://css-tricks.com/debouncing-throttling-explained-examples/
 * Если debounce вызвана впервые после timeout мс с последнего вызова cb, то cb вызовется сразу.
 * Иначе Вызывает cb функцию c контекстом context не ранее, чем через timeout мс,
 *  при повторном debounce вызов cb откладывается
 *
 * @return {Function}
 */
export const debounce = (context, cb, timeout = 500) => {
    let timer = null
    let lastCallTime = null
    let memArgs = null

    let wrapper = () => {
        cb.apply(context, memArgs)
        timer = null
        lastCallTime = new Date()
    }

    return (...args) => {
        memArgs = args // запомним аргументы последнего "пинка"

        if (timer === null) {
            if ((new Date() - lastCallTime) > timeout + 1) {
                return wrapper()
            }
        } else {
            clearTimeout(timer)
        }

        timer = setTimeout(wrapper, timeout)
    }
}
