/**
 * Сравнивает один уровень содержимого двух массивов.
 * @template T
 * @param a {T[]}
 * @param b {T[]}
 * @returns {boolean}
 */
export function arrayEquals (a, b) {
    if (a.length !== b.length) return false
    for (var i = 0; i < a.length; ++i) {
        if (a[i] !== b[i]) return false
    }
    return true
}

/**
 * Сравнивает один уровень содержимого двух множеств.
 * @template T
 * @param a {Set.<T>}
 * @param b {Set.<T>}
 * @returns {boolean}
 */
export function setEquals (a, b) {
    if (a.size !== b.size) return false
    for (var i = 0; i < a.length; ++i) {
        if (!b.has(a[i])) return false
    }
    return true
}
