const DELETE_ERROR_CODES = [
    'ad53d285-5b61-4f85-8f93-3eef616a2fc4', // learnmodel_task_has_child
    '8305c655-7b0f-47bf-a8be-c81b96aceee3', // scorecalc_task_has_child
    '51133e53-ae52-45ba-9e87-29f704129d6d', // model_has_child
    'd7f662cb-190f-4b00-97c7-fb023faa0fd6' // score_has_child
]

/**
 * Выполняет первый раз deleter(force = false). Если происходит ошибка удаления, то спрашивает пользователя,
 * хочет ли он удалить сущности с зависимостями. Если пользователь согласен, вызывает deleter(force = true).
 * @param ids {string[]} список id удаляемых объектов
 * @param deleter {CallableFunction} (ids, force) -> { deletes, errors }
 * @return {Promise<void>}
 */
export async function tryDelete (ids, deleter) {
    let { deletes, errors } = await deleter(ids, false)
    const hasErrors = Object.keys(errors).length !== 0
    const onlyDeleteErrors = Object.values(errors).every(e => DELETE_ERROR_CODES.includes(e.code))

    if (hasErrors && onlyDeleteErrors) {
        const message = ids.length === 1
            ? 'У удаляемого объекта есть зависимости, все равно удалить?'
            : 'У удаляемых объектов есть зависимости, все равно удалить?'
        if (confirm(message)) {
            const forceIds = ids.filter(id => !deletes.includes(id))
            const { deletes: forceDeletes, errors: forceErrors } = await deleter(forceIds, true)
            deletes.push(...forceDeletes)
            errors = forceErrors
        } else {
            errors = {}
        }
    }

    return { deletes, errors }
}
