import Vue from 'vue'

const defaultOptions = {
    group: 'app'
}

export const showNotify = (text, title, options) => {
    Vue.notify({
        ...defaultOptions,
        title: title,
        text: text,
        ...options
    })
}

export const cleanNotify = (group = defaultOptions.group) => {
    Vue.notify({
        group,
        clean: true
    })
}

export const showSuccess = (text, title = 'Сообщение', options) => {
    showNotify(text, title, {
        ...options,
        type: 'success',
        duration: 5000
    })
}

export const showError = (text, title = 'Ошибка', options) => {
    showNotify(text, title, {
        ...options,
        type: 'error',
        duration: 20000
    })
}

export const showApiError = (error, defaultText = 'Неизвестная ошибка', title = 'Ошибка', options) => {
    let text = (error.response && error.response.data && error.response.data.message) || defaultText
    const code = error.response && error.response.data && error.response.data.code && error.response.data.code.substring(0, 6)
    if (code) {
        text += ` (код: ${error.response.data.code.substring(0, 6)})`
    }
    showNotify(text, title, {
        ...options,
        type: 'error',
        duration: 20000
    })
    if (text === defaultText) console.error(error)
}
