import { ROUTES } from '../router'

export const redirectToLogin = router => {
    const currentPath = `${window.location.pathname}${window.location.search}`
    if (currentPath.startsWith('/login')) return

    let route = { name: ROUTES.LOGIN }
    if (currentPath !== '/') route.query = { next: currentPath }
    router.push(route)
}

export const getCurrentTimezone = () => {
    return Intl.DateTimeFormat().resolvedOptions().timeZone
}

/**
 * @param date {Date}
 * @param seconds {Number}
 * @returns {Date}
 */
export const startOfMonth = (date, seconds = 1) => {
    if (!date) return date

    return new Date(date.getFullYear(), date.getMonth(), 1, 0, 0, seconds)
}

/**
 * @param date {Date}
 * @param seconds
 * @returns {Date}
 */
export const endOfMonth = (date, seconds = 1) => {
    if (!date) return date

    const tmp = new Date(date.getFullYear(), date.getMonth() + 1)
    return new Date(tmp - seconds)
}

/**
 * @param date {Date}
 * @return {Date}
 */
export const endOfDay = (date) => {
    let t = new Date(date)
    t.setHours(24, 0, 0, -1)
    return t
}

/**
 * @param values {Array}
 * @param key {string}
 * @return {?Array}
 */
export const getKeysOrNull = (values, key = 'id') => {
    if (!values) return null

    return values.map(e => e[key])
}

/**
 * @param values {Array}
 * @param key {string}
 * @param separator {string}
 * @return {?string}
 */
export const joinValuesOrNull = (values, key = 'id', separator = ',') => {
    if (!values) return null

    return getKeysOrNull(values, key).join(separator)
}

export const periodCmp = (a, b, sortMode) => {
    console.log(a, b, sortMode)
    if (a.begin === b.begin) return 0
    if (a.begin === null || a.begin === undefined) return -sortMode
    if (b.begin === null || b.begin === undefined) return sortMode
    if (a.begin > b.begin) return sortMode
    if (a.begin < b.begin) return -sortMode

    return 1
}

export function toCellValue (text) {
    return `"${text}"`
}

/**
 * Вставляет item после элементов, которые удовлетворяют условию condition.
 * Если ни один элемент не удовлетворяет условию - вставляет в начало массива.
 * @param array
 * @param item
 * @param condition
 */
export function insertAfter (array, item, condition) {
    let idx = 0
    while (idx < array.length && condition(array[idx])) {
        idx += 1
    }
    array.splice(idx, 0, item)
}
